package com.ejie.ab18a.control;

import com.ejie.ab18a.service.Ab18aAplicacionInvocanteService;
import com.ejie.ab18a.service.Ab18aPeticionEnvioService;
import com.ejie.ab18a.service.Ab18aTicketPeticionService;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.ab18a.model.Ab18aAplicacionInvocante;
import com.ejie.ab18a.model.Ab18aPeticionEnvio;
import com.ejie.ab18a.model.Ab18aTicketPeticion;

/**
 * Ab18a01s00Controller generated by XXXX, 03-feb-2017 12:02:33.
 * 
 * @author XXXX
 */

@Controller
@RequestMapping(value = "/ab18aPeticionEnvio")
public class Ab18aPeticionEnvioController {

	private static final Logger logger = LoggerFactory
			.getLogger(Ab18aPeticionEnvioController.class);

	@Autowired
	private Ab18aPeticionEnvioService ab18aPeticionEnvioService;

	@Autowired
	private Ab18aTicketPeticionService ab18aTicketPeticionService;

	@Autowired
	private Ab18aAplicacionInvocanteService ab18aAplicacionInvocanteService;

	/*
	 * OPERACIONES CRUD (Create, Read, Update, Delete)
	 */

	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador
	 * indicado.
	 * 
	 * @param t01IdPeticionEnvio
	 *            Long
	 * @return Ab18a01s00 Objeto correspondiente al identificador indicado.
	 */
	@RequestMapping(value = "/{t01IdPeticionEnvio}", method = RequestMethod.GET)
	public @ResponseBody
	Ab18aPeticionEnvio get(@PathVariable Integer t01IdPeticionEnvio) {
		Ab18aPeticionEnvio ab18a01s00 = new Ab18aPeticionEnvio();
		ab18a01s00.setT01IdPeticionEnvio(t01IdPeticionEnvio);
		ab18a01s00 = this.ab18aPeticionEnvioService.find(ab18a01s00);
		Ab18aPeticionEnvioController.logger
				.info("[GET - findBy_PK] : Obtener Ab18a01s00 por PK");
		return ab18a01s00;
	}

	/**
	 * Devuelve una lista de beans correspondientes a los valores de filtrados
	 * indicados en el objeto pasado como parametro.
	 * 
	 * @param filterAb18a01s00
	 *            Ab18a01s00 Objeto que contiene los parametros de filtrado
	 *            utilizados en la busqueda.
	 * @return List<Ab18a01s00> Lista de objetos correspondientes a la busqueda
	 *         realizada.
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Ab18aPeticionEnvio> getAll(
			@ModelAttribute Ab18aPeticionEnvio filterAb18a01s00) {
		Ab18aPeticionEnvioController.logger
				.info("[GET - find_ALL] : Obtener Ab18a01s00 por filtro");
		return this.ab18aPeticionEnvioService.findAll(filterAb18a01s00, null);
	}

	/**
	 * Operacion CRUD Edit. Modificacion del bean indicado.
	 * 
	 * @param ab18a01s00
	 *            Ab18a01s00 Bean que contiene la informacion a modificar.
	 * @return Ab18a01s00 Bean resultante de la modificacion.
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Ab18aPeticionEnvio edit(@RequestBody Ab18aPeticionEnvio ab18a01s00) {
		Ab18aPeticionEnvio ab18a01s00Aux = this.ab18aPeticionEnvioService
				.update(ab18a01s00);
		Ab18aPeticionEnvioController.logger
				.info("[PUT] : Ab18a01s00 actualizado correctamente");
		return ab18a01s00Aux;
	}

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
	 * indicado.
	 * 
	 * @param ab18a01s00
	 *            Ab18a01s00 Bean que contiene la informacion con la que se va a
	 *            crear el nuevo registro.
	 * @return Ab18a01s00 Bean resultante del proceso de creacion.
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Ab18aPeticionEnvio add(@RequestBody Ab18aPeticionEnvio ab18a01s00)
			throws Exception {
		Ab18aPeticionEnvio ab18a01s00Aux = this.ab18aPeticionEnvioService
				.add(ab18a01s00);
		Ab18aPeticionEnvioController.logger
				.info("[POST] : Ab18a01s00 insertado correctamente");
		return ab18a01s00Aux;
	}

	/**
	 * Operacion CRUD Delete. Borrado del registro correspondiente al
	 * identificador especificado.
	 * 
	 * @param t01IdPeticionEnvio
	 *            Long Identificador del objeto que se desea eliminar.
	 * @return Ab18a01s00 Bean eliminado.
	 */
	@RequestMapping(value = "/{t01IdPeticionEnvio}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Ab18aPeticionEnvio remove(@PathVariable Integer t01IdPeticionEnvio) {
		Ab18aPeticionEnvio ab18a01s00 = new Ab18aPeticionEnvio();
		ab18a01s00.setT01IdPeticionEnvio(t01IdPeticionEnvio);
		this.ab18aPeticionEnvioService.remove(ab18a01s00);
		Ab18aPeticionEnvioController.logger
				.info("[DELETE] : Ab18a01s00 borrado correctamente");
		return ab18a01s00;
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE
	 */

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		Ab18aPeticionEnvioController.logger.info("[GET - View] : ab18a01s00");
		try {
			// recibimos una petici�n de ticket, comprobamos la aplicacion
			// invocante
			// y registramos en BBDD en T07
			Integer t03IdAplicacion = 1;
			Ab18aAplicacionInvocante aplicacionInvocante = new Ab18aAplicacionInvocante(
					t03IdAplicacion);
			aplicacionInvocante = this.ab18aAplicacionInvocanteService
					.find(aplicacionInvocante);

			if (aplicacionInvocante.getT03DescEs() != null
					&& !aplicacionInvocante.getT03DescEs().equals("")) {

				Ab18aTicketPeticion ticketPeticion = new Ab18aTicketPeticion();
				ticketPeticion.setT03IdAplicacion(aplicacionInvocante
						.getT03IdAplicacion());
				ticketPeticion.setT07FechaPeticion(new Date());
				ticketPeticion.setT07Ticket("Ticket Prueba");
				try {
					ticketPeticion = this.ab18aTicketPeticionService
							.add(ticketPeticion);
				} catch (Exception e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}

				/*** RECIBIMOS LA PETICION DE ENVIO ***/
				Ab18aPeticionEnvio peticionEnvio = new Ab18aPeticionEnvio();

				// recogemos la peticion de envio

				// realizamos las validaciones generales

				// realizamos las validaciones especificas

				// almacenamos la peticion en BBDD

				this.ab18aPeticionEnvioService.add(peticionEnvio);

				// enviar respuesta del servicio a las aplicaciones invocantes

			} else {
				// error, no existe la aplicacion invocante en nuestra BBDD
				// System.out.println("Error: NO existe la aplicacion");
				Ab18aPeticionEnvioController.logger
						.error("Error: NO existe la aplicacion");
			}
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		return "ab18aPeticionEnvio";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * @param filterAb18a01s00
	 *            Ab18a01s00 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<Ab18a01s00> Dto que contiene el resultado del
	 *         filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<Ab18aPeticionEnvio> filter(
			@RequestJsonBody(param = "filter") Ab18aPeticionEnvio filterAb18a01s00,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Ab18aPeticionEnvioController.logger
				.info("[POST - filter] : Obtener Ab18a01s00s");
		return this.ab18aPeticionEnvioService.filter(filterAb18a01s00,
				jqGridRequestDto, false);
	}

	/**
	 * Operacion de busqueda del componente RUP_TABLE.
	 * 
	 * @param filterAb18a01s00
	 *            Ab18a01s00 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param searchAb18a01s00
	 *            Ab18a01s00 Bean que contiene los parametros de busqueda a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la búsqueda.
	 * @return TableRowDto<Ab18a01s00> Dto que contiene el resultado de la
	 *         busqueda realizada por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/search", method = RequestMethod.POST)
	public @ResponseBody
	List<TableRowDto<Ab18aPeticionEnvio>> search(
			@RequestJsonBody(param = "filter") Ab18aPeticionEnvio filterAb18a01s00,
			@RequestJsonBody(param = "search") Ab18aPeticionEnvio searchAb18a01s00,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Ab18aPeticionEnvioController.logger
				.info("[POST - search] : Buscar Ab18a01s00s");
		return this.ab18aPeticionEnvioService.search(filterAb18a01s00,
				searchAb18a01s00, jqGridRequestDto, false);
	}

	/**
	 * Borrado multiple de registros
	 * 
	 * @param filterAb18a01s00
	 *            Ab18a01s00 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la busqueda.
	 * @return List<String> Lista de los identificadores de los registros
	 *         eliminados.
	 * 
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<String> removeMultiple(
			@RequestJsonBody(param = "filter") Ab18aPeticionEnvio filterAb18a01s00,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Ab18aPeticionEnvioController.logger
				.info("[POST - search] : [POST - removeMultiple] : Eliminar multiples Ab18a01s00s");
		this.ab18aPeticionEnvioService.removeMultiple(filterAb18a01s00,
				jqGridRequestDto, false);
		Ab18aPeticionEnvioController.logger
				.info("All entities correctly deleted!");

		return jqGridRequestDto.getMultiselection().getSelectedIds();
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE - JERARQUIA
	 */

	/**
	 * Operacion de filtrado del componente RUP_TABLE para presentar los
	 * registros mediante visualizacion jerarquica.
	 * 
	 * @param filterAb18a01s00
	 *            Ab18a01s00 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<JerarquiaDto<Ab18a01s00>> Dto que contiene el
	 *         resultado del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/jerarquia/filter", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<JerarquiaDto<Ab18aPeticionEnvio>> jerarquia(
			@RequestJsonBody(param = "filter") Ab18aPeticionEnvio filterAb18a01s00,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Ab18aPeticionEnvioController.logger
				.info("[POST - jerarquia] : Obtener Ab18a01s00s jerarquia");
		return this.ab18aPeticionEnvioService.jerarquia(filterAb18a01s00,
				jqGridRequestDto, false);
	}

	/**
	 * Recupera los hijos de los registros desplegados en la visualizacion
	 * jerarquica.
	 * 
	 * @param filterAb18a01s00
	 *            Ab18a01s00 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<JerarquiaDto<Ab18a01s00>> Dto que contiene el
	 *         resultado del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/jerarquiaChildren", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<JerarquiaDto<Ab18aPeticionEnvio>> jerarquiaChildren(
			@RequestJsonBody(param = "filter") Ab18aPeticionEnvio filterAb18a01s00,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Ab18aPeticionEnvioController.logger
				.info("[POST - jerarquia] : Obtener Ab18a01s00s jerarquia - Hijos");
		return this.ab18aPeticionEnvioService.jerarquiaChildren(
				filterAb18a01s00, jqGridRequestDto);
	}

}
